/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package viewer;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import com.inet.viewer.SwingReportViewer;
import com.inet.viewer.SwingViewerContext;

/**
 * This is a quick example of how simply you can replace certain actions in the i-net Clear Reports viewer, starting in
 * version 7.0. This will create an empty Viewer and replace the Info action, which normally would display an i-net
 * Clear Reports info dialog, instead showing a custom Info Dialog.
 * <p>
 * This is done by setting a custom "ViewerContext" for the viewer. This example could easily be changed to implement
 * your own error handling, printing, or exporting behavior.
 */
public class ReplaceInfoButton {

    // Note that the new Viewer cannot be added to an AWT Frame.
    private static JFrame frame = new JFrame( "i-net Clear Reports Viewer" );

    /**
     * Replace the info action of the Java viewer.
     */
    public static void initGUI() {
        frame.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );

        // Here we create our Viewer instance
        final SwingReportViewer viewer = new SwingReportViewer();

        // Now we replace the viewer context with our own.
        viewer.setViewerContext( new CustomViewerContext( viewer ) );

        frame.getContentPane().add( viewer );

        //Display the window.
        frame.pack();

        frame.setVisible( true );

    }

    /**
     * Main method of this sample
     * @param args arguments not used
     */
    public static void main( String[] args ) {
        initGUI();
    }
}

/**
 * Here is our custom Viewer Context which allows us to handle the info action ourselves.
 */
class CustomViewerContext extends SwingViewerContext {

    CustomViewerContext( SwingReportViewer viewer ) {
        super( viewer );
    }

    /**
     * Shows Info message
     */
    @Override
    public void showInfo() {
        JOptionPane.showMessageDialog( null, "<html>\"Hardware: the parts of a computer that can be kicked.\"<br> - Jeff Pesis</html>" );
    }
}
